library(ggplot2)
library(ggpubr)
library(cowplot)
library(reshape2)
library(forcats)
args=commandArgs(T)
file1 <- args[1]
file2 <- args[2]
file3 <- args[3]
data1 <- read.table(file1,header = F)
data2 <- read.table(file2,header = F)
colnames(data1) <- c("id","zheng","fu")
colnames(data2) <- c("id","zheng","fu")
a <- data1$id
b <- data1$zheng+data2$zheng
c <- data1$fu+data2$fu
data <- data.frame(a,b,c)
colnames(data) <- c("id","zheng","fu")
data$id <- fct_inorder(data$id)
data$fu <- -data$fu
max <- max(data$zheng)+10
min <- min(data$fu)-10
a <- ggplot(data,aes(x=id,y=zheng))+geom_bar(stat = "identity",fill="red")+theme_classic()+scale_y_continuous(limits=c(0,max),expand = c(0,0))+theme(axis.text.x = element_blank())+xlab("")+ylab("")+theme(axis.ticks.x = element_blank())
b <- ggplot(data,aes(x=id,y=fu))+geom_bar(stat = "identity",fill="blue")+theme_classic()+theme(axis.text.x = element_blank())+xlab("")+ylab("")+theme(axis.ticks.x = element_blank())+scale_y_continuous(limits=c(min,0),expand = c(0,0))

c <- plot_grid(a,b ,nrow=2,align = "hv")          
pdf(file3,width=8,height=8)
c
dev.off()                                                                                                                                                                                                     


